package com.genexus.printing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.json.*;

//imports for https
import com.sun.net.httpserver.HttpsServer;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import com.sun.net.httpserver.*;
import java.io.FileInputStream;
import java.net.URLDecoder;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLContext;

//import for reading file properties
import java.util.Properties;

public class gxprintserver {

    //read properties from file
    static String port;
    static String certLocation;
    static String certPassword;
    static String protocol;
        
    public static void main(String[] args) throws Exception {

        //set default values for port and protocol
        port = "8000";
        protocol = "http";
         
        //get gxprintserver.properties for reading 
        String path = gxprintserver.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = URLDecoder.decode(path, "UTF-8");
        decodedPath = decodedPath.substring(0, path.lastIndexOf("/") + 1);
        
        try (InputStream input = new FileInputStream(decodedPath + "gxprintserver.properties")) {
           
            Properties prop = new Properties();

            // load a properties file
            prop.load(input);

            // get the properties values
            port = prop.getProperty("gxprintserver.port");
            protocol = prop.getProperty("gxprintserver.protocol");
            certLocation = prop.getProperty("gxprintserver.certLocation");
            certPassword = prop.getProperty("gxprintserver.certPassword");
            
        } catch (IOException ex) {
            //gxprintserver.properties file can't be found. Print custom message.
            System.out.println("WARNING: could not find gxprintserver.properties file. A default port (8000) and protocol (http) will be used.");
        }
            
        if(port == null || port.length() == 0){
            throw new Exception("ERROR: the port property of gxprintserver.properties can't be empty. You must specify a port." );
        } else {
            //depending on protocol specification, create http or https server
            if("http".equals(protocol)){
                //HTTP
                try {
                    HttpServer server = HttpServer.create(new InetSocketAddress(Integer.parseInt(port)), 0);
                    server.createContext("/print", new MyHandler());
                    server.setExecutor(Executors.newCachedThreadPool());
                    server.start();

                    System.out.println("SUCCESS: HTTP Print server listening at port: " + port);

                } catch (Exception exception) {
                    System.out.println("ERROR: Failed to create HTTP server on port " + port + " of localhost");
                    exception.printStackTrace();
                }

            }else{
                if("https".equals(protocol)){

                    if(certLocation == null || certLocation.length() == 0){
                         throw new Exception("ERROR: If you are using HTTPS, the certLocation property of gxprintserver.properties can't be empty." );
                    } else {
                        if(certPassword == null || certPassword.length() == 0){
                            throw new Exception("ERROR: If you are using HTTPS, the certPassword property of gxprintserver.properties can't be empty." );
                        } else {

                            //HTTPS
                            try {
                                // setup the socket address
                                InetSocketAddress address = new InetSocketAddress(Integer.parseInt(port));

                                // initialise the HTTPS server
                                HttpsServer httpsServer = HttpsServer.create(address, 0);
                                SSLContext sslContext = SSLContext.getInstance("TLS");

                                // initialise the keystore
                                char[] password = certPassword.toCharArray();
                                KeyStore ks = KeyStore.getInstance("JKS");
                                FileInputStream fis = new FileInputStream(certLocation);
                                ks.load(fis, password);

                                // setup the key manager factory
                                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                                kmf.init(ks, password);

                                // setup the trust manager factory
                                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                                tmf.init(ks);

                                // setup the HTTPS context and parameters
                                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                                httpsServer.setHttpsConfigurator(new HttpsConfigurator(sslContext) {
                                    @Override
                                    public void configure(HttpsParameters params) {
                                        try {
                                            // initialise the SSL context
                                            SSLContext context = getSSLContext();
                                            SSLEngine engine = context.createSSLEngine();
                                            params.setNeedClientAuth(false);
                                            params.setCipherSuites(engine.getEnabledCipherSuites());
                                            params.setProtocols(engine.getEnabledProtocols());

                                            // Set the SSL parameters
                                            SSLParameters sslParameters = context.getSupportedSSLParameters();
                                            params.setSSLParameters(sslParameters);

                                        } catch (Exception ex) {
                                            System.out.println("Failed to create HTTPS port: " + ex);
                                        }
                                    }
                                });
                                httpsServer.createContext("/printsecure", new MyHandler());
                                httpsServer.setExecutor(Executors.newCachedThreadPool()); // creates a default executor
                                httpsServer.start();

                                System.out.print("SUCCESS: HTTPS Print server listening at port: " + port);

                            } catch (Exception exception) {
                                System.out.println("ERROR: Failed to create HTTPS server on port " + port + " of localhost");
                                exception.printStackTrace();
                            }

                        }
                    }               

                } else {
                    throw new Exception("ERROR: the protocol property of gxprintserver.properties file supports only the following values: http/https and can't be empty." );
                }

            } 
        }
    }
    
 // convert InputStream to String
    private static String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();

        String line;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    static class MyHandler implements HttpHandler {
        @Override
        public void handle(HttpExchange t) throws IOException {
        	
            String response;
            InputStream is = t.getRequestBody();
            String request = getStringFromInputStream( is);
            is.close();
            
            String reportFile = "";
            String printerRule = "";
            String baseURL = "";
            String iniUrl = "gxprn.ini";
            
            boolean status;
            JSONObject jsonResponse = new JSONObject();
            if (request.length() > 0) {
                JSONObject obj = new JSONObject(request);

                reportFile = obj.getString("reportFile");
                printerRule = obj.has("printerRule") ? obj.getString("printerRule") : "";
                baseURL = obj.has("baseURL") ? obj.getString("baseURL") : "";
                Printer printer = new Printer( baseURL);
      
                status = printer.printReport( reportFile, printerRule, iniUrl);
            }
            else
            {
                status = true;
            }
            jsonResponse.put("Status", status);            
            Headers h = t.getResponseHeaders();
            h.add("Access-Control-Allow-Origin", "*");
            h.add("Content-Type", "application/json");
            
            response = jsonResponse.toString();
            t.sendResponseHeaders( status ? 200 : 500, response.length());
            OutputStream os = t.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }
    }

}